% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{getX_multi_exposure}
\alias{getX_multi_exposure}
\title{Generate multi-exposure data with genetic instruments}
\usage{
getX_multi_exposure(
  N = 10000,
  J = 30,
  ZXmodel = "A",
  nSparse = 10,
  NT = 1000,
  TT = 50,
  shared_effect = TRUE,
  separate_G = FALSE,
  shared_G_proportion = 0.15
)
}
\arguments{
\item{N}{Sample size}

\item{J}{Number of genetic instruments}

\item{ZXmodel}{Model type (currently not used)}

\item{nSparse}{Number of sparse observations per subject}

\item{NT}{Number of points}

\item{TT}{Max observation period}

\item{shared_effect}{Whether X1 and X2 share confounding}

\item{separate_G}{Whether to use separate instruments for each exposure}

\item{shared_G_proportion}{Proportion of shared instruments (0-1)}
}
\value{
List with X1, X2 sparse data and genetic instruments
}
\description{
Generate multi-exposure data with genetic instruments
}
