% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmissionRates.R
\name{transmissionRates}
\alias{transmissionRates}
\title{Calculate transmission rate matrix for multi-group model with specified R0}
\usage{
transmissionRates(R0, meaninf, reltransm)
}
\arguments{
\item{R0}{overall basic reproduction number}

\item{meaninf}{mean duration of infectious period}

\item{reltransm}{matrix with relative transmission rates, from column-group to row-group}
}
\value{
a matrix of transmission rates to (row) and from (column) each group,
in same time units as meaninf
}
\description{
Calculate transmission rate matrix for multi-group model with specified R0
}
\examples{
transmissionRates(R0 = 15, meaninf = 7,
  reltransm = rbind(c(1, 0.5, 0.9), c(0.3, 1.9, 1), c(0.3, 0.6, 2.8)))
}
