% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/inputs.R
\name{Button}
\alias{Button}
\alias{Button.shinyInput}
\alias{updateButton.shinyInput}
\title{Button}
\usage{
Button(...)

Button.shinyInput(inputId, ...)

updateButton.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.}

\item{inputId}{ID of the component.}

\item{session}{Object passed as the `session` argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/button/}
}
\details{
\itemize{
\item children \code{node} \cr Default is - The content of the component.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item color \code{'inherit'| 'primary'| 'secondary'| 'success'| 'error'| 'info'| 'warning'| string} \cr Default is 'primary' The color of the component. It supports both default and custom theme colors, which can be added as shown in the palette customization guide.
\item component \code{elementType} \cr Default is - The component used for the root node. Either a string to use a HTML element or a component.
\item disabled \code{bool} \cr Default is FALSE If true, the component is disabled.
\item disableElevation \code{bool} \cr Default is FALSE If true, no elevation is used.
\item disableFocusRipple \code{bool} \cr Default is FALSE If true, the keyboard focus ripple is disabled.
\item disableRipple \code{bool} \cr Default is FALSE If true, the ripple effect is disabled.  Without a ripple there is no styling for :focus-visible by default. Be sure to highlight the element by applying separate styles with the .Mui-focusVisible class.
\item endIcon \code{node} \cr Default is - Element placed after the children.
\item fullWidth \code{bool} \cr Default is FALSE If true, the button will take up the full width of its container.
\item href \code{string} \cr Default is - The URL to link to when the button is clicked. If defined, an a element will be used as the root node.
\item loading \code{bool} \cr Default is null If true, the loading indicator is visible and the button is disabled. If true | false, the loading wrapper is always rendered before the children to prevent Google Translation Crash.
\item loadingIndicator \code{node} \cr Default is CircularProgress color="inherit" size=16 / Element placed before the children if the button is in loading state. The node should contain an element with role="progressbar" with an accessible name. By default, it renders a CircularProgress that is labeled by the button itself.
\item loadingPosition \code{'center'| 'end'| 'start'} \cr Default is 'center' The loading indicator can be positioned on the start, end, or the center of the button.
\item size \code{'small'| 'medium'| 'large'| string} \cr Default is 'medium' The size of the component. small is equivalent to the dense button styling.
\item startIcon \code{node} \cr Default is - Element placed before the children.
\item sx \verb{Array func| object| bool | func| object} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item variant \code{'contained'| 'outlined'| 'text'| string} \cr Default is 'text' The variant to use.
}
}
