% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/K_sim.R
\name{K_sim}
\alias{K_sim}
\title{Carrying Capacity Map Simulator}
\usage{
K_sim(n, id, range, cor_mat = NULL, qfun = qnorm, ...)
}
\arguments{
\item{n}{Integer. Number of maps to generate.}

\item{id}{A \code{\link[terra:SpatRaster-class]{SpatRaster}} object used as a geographic template.}

\item{range}{Numeric. Spatial autocorrelation parameter passed to the \code{grf} function.}

\item{cor_mat}{Optional correlation matrix. If \code{NULL}, maps are generated independently.}

\item{qfun}{Quantile function to apply to the generated GRFs (default: \code{\link[stats:Normal]{qnorm}}).}

\item{...}{Additional arguments passed to the quantile function \code{qfun}.}
}
\value{
A \code{\link[terra:SpatRaster-class]{SpatRaster}} object with \code{n} layers, each representing a carrying capacity map.
}
\description{
Generates multiple carrying capacity maps based on spatially autocorrelated Gaussian Random Fields (GRFs), with optional correlation between layers.
}
\examples{
library(terra)
library(FieldSimR)

# Community parameters
nspec <- 3
nrows <- ncols <- 10
xmin <- 250000; xmax <- xmin + nrows * 1000
ymin <- 600000; ymax <- ymin + ncols * 1000
id <- rast(nrows = nrows, ncols = ncols, xmin = xmin, xmax = xmax, ymin = ymin, ymax = ymax)
crs(id) <- "epsg:2180"
plot(id)

# Correlation matrix of carrying capacities
cor_mat <- matrix(c(1, 0.29, 0.32, 0.29, 1, 0.32, 0.32, 0.32, 1), nrow = nspec, ncol = nspec)
cor_mat

# Generate and define the distributions and parameters of correlated carrying capacity maps
K_map <- K_sim(nspec, id, range = 20000, cor_mat = cor_mat, qfun = qlnorm, meanlog = 2, sdlog = 0.5)
K_map
hist(K_map)
plot(K_map)

}
