% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{list_current_tables}
\alias{list_current_tables}
\title{List Tables in the Current Database and Schema}
\usage{
list_current_tables(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A \code{dbplyr} lazy tibble with columns:
\itemize{
\item \code{table_catalog} — the current database.
\item \code{table_schema}  — the current schema.
\item \code{table_name}    — each table name.
}
}
\description{
Returns a lazy tibble of all tables that exist in the \strong{current database}
and \strong{current schema} of the active connection.
Queries the standard \code{information_schema.tables} view and filters to
\code{current_database()} and \code{current_schema()}.
}
\details{
\itemize{
\item This function validates that the connection is valid with \code{validate_con()}.
\item Result is a \code{dbplyr} lazy table (\code{tbl_dbi}); call \code{collect()} to bring it
into R.
}
}
\seealso{
Other db-list: 
\code{\link{list_all_databases}()},
\code{\link{list_all_tables}()},
\code{\link{list_current_schemas}()},
\code{\link{list_extensions}()},
\code{\link{list_fns}()},
\code{\link{list_setting}()},
\code{\link{list_shares}()}
}
\concept{db-list}
