% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{delete_and_create_schema}
\alias{delete_and_create_schema}
\title{Drop and Recreate a Schema in a MotherDuck / DuckDB Database}
\usage{
delete_and_create_schema(.con, database_name, schema_name)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{database_name}{The name of the database where the schema should be
dropped and recreated.}

\item{schema_name}{The name of the schema to drop and recreate.}
}
\value{
Invisibly returns \code{NULL}.
Side effect: drops and recreates the schema and prints CLI status messages.
}
\description{
Drops an existing schema (if it exists) in the specified database and then
creates a new empty schema.
If the connection is to a MotherDuck instance, the function switches to the
given database first, then drops and recreates the schema.
Displays helpful CLI output about the current connection, user, and database.
}
\details{
\itemize{
\item Executes \verb{DROP SCHEMA IF EXISTS ... CASCADE} to remove an existing schema
and all contained objects.
\item Executes \verb{CREATE SCHEMA IF NOT EXISTS} to recreate it.
\item If connected to MotherDuck (detected by
\code{validate_md_connection_status()}), performs a \verb{USE <database>} first.
\item Prints a summary of the current connection and schema creation status
using internal CLI helpers.
}
}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
