% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{response}
\alias{response}
\alias{response.default}
\title{Get the response variable for a mlearning object}
\usage{
response(object, ...)

\method{response}{default}(object, ...)
}
\arguments{
\item{object}{an object having a response variable.}

\item{...}{further parameter (depends on the method).}
}
\value{
The response variable of the training set, or \code{NULL} for unsupervised
classification.
}
\description{
The response is either the class to be predicted for a classification problem
(and it is a factor), or the dependent variable in a regression model (and
it is numeric in that case). For unsupervised classification, response is not
provided and should return \code{NULL}.
}
\examples{
data("HouseVotes84", package = "mlbench")
house_rf <- ml_rforest(data = HouseVotes84, Class ~ .)
house_rf
response(house_rf)
}
\seealso{
\code{\link[=mlearning]{mlearning()}}, \code{\link[=train]{train()}}, \code{\link[=confusion]{confusion()}}
}
