% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_svm.R
\name{mlSvm}
\alias{mlSvm}
\alias{ml_svm}
\alias{mlSvm.formula}
\alias{mlSvm.default}
\alias{predict.mlSvm}
\title{Supervised classification and regression using support vector machine}
\usage{
mlSvm(train, ...)

ml_svm(train, ...)

\method{mlSvm}{formula}(
  formula,
  data,
  scale = TRUE,
  type = NULL,
  kernel = "radial",
  classwt = NULL,
  ...,
  subset,
  na.action
)

\method{mlSvm}{default}(
  train,
  response,
  scale = TRUE,
  type = NULL,
  kernel = "radial",
  classwt = NULL,
  ...
)

\method{predict}{mlSvm}(
  object,
  newdata,
  type = c("class", "membership", "both"),
  method = c("direct", "cv"),
  na.action = na.exclude,
  ...
)
}
\arguments{
\item{train}{a matrix or data frame with predictors.}

\item{...}{further arguments passed to the classification or regression
method. See \code{\link[e1071:svm]{e1071::svm()}}.}

\item{formula}{a formula with left term being the factor variable to predict
(for supervised classification), a vector of numbers (for regression) or
nothing (for unsupervised classification) and the right term with the list
of independent, predictive variables, separated with a plus sign. If the
data frame provided contains only the dependent and independent variables,
one can use the \code{class ~ .} short version (that one is strongly encouraged).
Variables with minus sign are eliminated. Calculations on variables are
possible according to usual formula convention (possibly protected by using
\code{I()}).}

\item{data}{a data.frame to use as a training set.}

\item{scale}{are the variables scaled (so that mean = 0 and standard
deviation = 1)? \code{TRUE} by default. If a vector is provided, it is applied
to variables with recycling.}

\item{type}{For \code{\link[=ml_svm]{ml_svm()}}/\code{\link[=mlSvm]{mlSvm()}}, the type of classification or
regression machine to use. The default value of \code{NULL} uses
\code{"C-classification"} if response variable is factor and  \code{eps-regression}
if it is numeric. It can also be \code{"nu-classification"} or
\code{"nu-regression"}. The "C" and "nu" versions are basically the same but
with a different parameterisation. The range of C is from zero to infinity,
while the range for nu is from zero to one. A fifth option is
\code{"one_classification"} that is specific to novelty detection (find the
items that are different from the rest).
For \code{\link[=predict]{predict()}}, the type of prediction to return. \code{"class"} by default,
the predicted classes. Other options are \code{"membership"} the membership
(number between 0 and 1) to the different classes, or  \code{"both"} to return
classes and memberships.}

\item{kernel}{the kernel used by svm, see \code{\link[e1071:svm]{e1071::svm()}} for further
explanations. Can be \code{"radial"}, \code{"linear"}, \code{"polynomial"} or \code{"sigmoid"}.}

\item{classwt}{priors of the classes. Need not add up to one.}

\item{subset}{index vector with the cases to define the training set in use
(this argument must be named, if provided).}

\item{na.action}{function to specify the action to be taken if \code{NA}s are
found. For \code{\link[=ml_svm]{ml_svm()}} \code{na.fail} is used by default. The calculation is
stopped if there is any \code{NA} in the data. Another option is \code{na.omit},
where cases with missing values on any required variable are dropped (this
argument must be named, if provided). For the \code{predict()} method, the
default, and most suitable option, is \code{na.exclude}. In that case, rows with
\code{NA}s in \verb{newdata=} are excluded from prediction, but reinjected in the
final results so that the number of items is still the same (and in the
same order as \verb{newdata=}).}

\item{response}{a vector of factor (classification) or numeric (regression).}

\item{object}{an \strong{mlSvm} object}

\item{newdata}{a new dataset with same conformation as the training set (same
variables, except may by the class for classification or dependent variable
for regression). Usually a test set, or a new dataset to be predicted.}

\item{method}{\code{"direct"} (default) or \code{"cv"}. \code{"direct"} predicts new cases in
\verb{newdata=} if this argument is provided, or the cases in the training set
if not. Take care that not providing \verb{newdata=} means that you just
calculate the \strong{self-consistency} of the classifier but cannot use the
metrics derived from these results for the assessment of its performances.
Either use a different data set in \verb{newdata=} or use the alternate
cross-validation ("cv") technique. If you specify \code{method = "cv"} then
\code{\link[=cvpredict]{cvpredict()}} is used and you cannot provide \verb{newdata=} in that case.}
}
\value{
\code{\link[=ml_svm]{ml_svm()}}/\code{\link[=mlSvm]{mlSvm()}} creates an \strong{mlSvm}, \strong{mlearning} object
containing the classifier and a lot of additional metadata used by the
functions and methods you can apply to it like \code{\link[=predict]{predict()}} or
\code{\link[=cvpredict]{cvpredict()}}. In case you want to program new functions or extract
specific components, inspect the "unclassed" object using \code{\link[=unclass]{unclass()}}.
}
\description{
Unified (formula-based) interface version of the support vector machine
algorithm provided by \code{\link[e1071:svm]{e1071::svm()}}.
}
\examples{
# Prepare data: split into training set (2/3) and test set (1/3)
data("iris", package = "datasets")
train <- c(1:34, 51:83, 101:133)
iris_train <- iris[train, ]
iris_test <- iris[-train, ]
# One case with missing data in train set, and another case in test set
iris_train[1, 1] <- NA
iris_test[25, 2] <- NA

iris_svm <- ml_svm(data = iris_train, Species ~ .)
summary(iris_svm)
predict(iris_svm) # Default type is class
predict(iris_svm, type = "membership")
predict(iris_svm, type = "both")
# Self-consistency, do not use for assessing classifier performances!
confusion(iris_svm)
# Use an independent test set instead
confusion(predict(iris_svm, newdata = iris_test), iris_test$Species)

# Another dataset
data("HouseVotes84", package = "mlbench")
house_svm <- ml_svm(data = HouseVotes84, Class ~ ., na.action = na.omit)
summary(house_svm)
# Cross-validated confusion matrix
confusion(cvpredict(house_svm), na.omit(HouseVotes84)$Class)

# Regression using support vector machine
data(airquality, package = "datasets")
ozone_svm <- ml_svm(data = airquality, Ozone ~ ., na.action = na.omit)
summary(ozone_svm)
plot(na.omit(airquality)$Ozone, predict(ozone_svm))
abline(a = 0, b = 1)
}
\seealso{
\code{\link[=mlearning]{mlearning()}}, \code{\link[=cvpredict]{cvpredict()}}, \code{\link[=confusion]{confusion()}}, also \code{\link[e1071:svm]{e1071::svm()}}
that actually does the calculation.
}
