% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cpt.R
\name{plot_cpt}
\alias{plot_cpt}
\title{Plot Conditional Probability Tables Comparison}
\usage{
plot_cpt(CPT_POP, CPT_MP)
}
\arguments{
\item{CPT_POP}{Matrix. Population-based conditional probability table,
typically output from \code{\link{cpt_population}}.}

\item{CPT_MP}{Matrix. Missing person-based conditional probability table,
typically output from \code{\link{cpt_missing_person}}.}
}
\value{
A \code{ggplot2} object with three panels arranged horizontally,
showing heatmaps with cell values annotated.
}
\description{
Creates a three-panel visualization comparing conditional probability
tables (CPTs) and their resulting likelihood ratios:
\itemize{
\item Panel A: P(D|H2) - Population-based probabilities
\item Panel B: P(D|H1) - Missing person-based probabilities
\item Panel C: log10(LR) - Likelihood ratios for each combination
}

This visualization helps understand how different combinations of
sex, age group, and hair color contribute to the likelihood ratio.
}
\details{
The heatmaps use a blue gradient where darker colors indicate higher
values (higher probabilities or higher LRs).

Each cell is labeled with its value rounded to 2 decimal places.

The LR panel (C) shows log10(LR), where:
\itemize{
\item Positive values (blue) favor H1 (related)
\item Negative values favor H2 (unrelated)
\item Zero indicates neutral evidence
}

Row labels indicate sex and age group combinations:
\itemize{
\item F-T1: Female, age within MP range
\item F-T0: Female, age outside MP range
\item M-T1: Male, age within MP range
\item M-T0: Male, age outside MP range
}

Column labels indicate hair color categories (1-5).
}
\examples{
# Create both CPTs
cpt_h2 <- cpt_population()
cpt_h1 <- cpt_missing_person(MPs = "F", MPc = 1)

# Visualize comparison
plot_cpt(cpt_h2, cpt_h1)

# Different MP characteristics
cpt_h1_male <- cpt_missing_person(MPs = "M", MPc = 3)
plot_cpt(cpt_h2, cpt_h1_male)
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{cpt_population}} for creating the H2 table,
\code{\link{cpt_missing_person}} for creating the H1 table.
}
