% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_reference_prop.R
\name{compute_reference_prop}
\alias{compute_reference_prop}
\title{Compute Reference Population Proportions for Pigmentation Traits}
\usage{
compute_reference_prop(data)
}
\arguments{
\item{data}{A data.frame with columns \code{hair_colour}, \code{skin_colour},
and \code{eye_colour}, typically output from \code{\link{sim_reference_pop}}.}
}
\value{
A data.frame with columns:
\itemize{
\item \code{hair_colour}: Hair color category
\item \code{skin_colour}: Skin color category
\item \code{eye_colour}: Eye color category
\item \code{f_h_s_y}: Population frequency of this combination
}
}
\description{
Computes the frequency of each unique combination of hair color, skin color,
and eye color in the reference population. These proportions serve as the
denominator (H2 probabilities) in LR calculations for pigmentation traits.
}
\examples{
# Generate reference population
pop_data <- sim_reference_pop(n = 500, seed = 123)

# Compute proportions
ref_prop <- compute_reference_prop(pop_data)
head(ref_prop)

# Most common combinations
ref_prop[order(-ref_prop$f_h_s_y), ][1:5, ]
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{sim_reference_pop}} for generating the input data,
\code{\link{compute_conditioned_prop}} for conditioned proportions,
\code{\link{lr_compute_pigmentation}} for computing LRs.
}
