% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual.R
\name{outline}
\alias{outline}
\title{Extract headings of (R) Markdown-syntax text as an outline}
\usage{
outline(
  from,
  md_list = FALSE,
  md_eq = FALSE,
  md_braces = FALSE,
  md_bookdown = FALSE,
  md_maxlevel = ""
)
}
\arguments{
\item{from}{Character. The source text of the (R) Markdown syntax text, the R code, the FreeMind mind map code, or the path to the directory.}

\item{md_list}{Logical. whether to process lists like headings in the Markdown input.}

\item{md_eq}{Logical. Whether to include LaTeX equations in the Markdown input when converted to other formats.}

\item{md_braces}{Logical. Whether to remove \href{https://bookdown.org/yihui/bookdown/cross-references.html}{{#ID}} in the headings of the markdown file (usually in a \href{https://github.com/rstudio/bookdown}{bookdown}> project.}

\item{md_bookdown}{Logical. Whether the R Markdown syntax text is in bookdown style, i.e. \code{# (PART), # (APPENDIX)}, and \code{# References} as an upper level of the Level 1 heading.}

\item{md_maxlevel}{Integer or ''. The maximum level of the markdown headings that are displayed in the mind map.}
}
\value{
Character, showing the outline.
}
\description{
Extract headings of (R) Markdown-syntax text as an outline
}
