% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_tidy_api.R
\name{publish_workflow}
\alias{publish_workflow}
\title{Publish a workflow to the active backend}
\usage{
publish_workflow(wf)
}
\arguments{
\item{wf}{A RecipeWorkflow object.}
}
\value{
NULL (called for side effect).
}
\description{
Publishes a RecipeWorkflow to the configured workflow backend.
}
\examples{
set_workflow_backend("local", path = tempfile(fileext = ".json"))
wf <- RecipeWorkflow$new(
  name = "Example", description = "Test",
  survey_type = "ech", edition = "2023",
  recipe_ids = "r_001", estimation_type = "svymean"
)
publish_workflow(wf)

}
\seealso{
\code{\link{set_workflow_backend}}, \code{\link{RecipeWorkflow}}

Other workflows: 
\code{\link{RecipeWorkflow-class}},
\code{\link{evaluate_cv}()},
\code{\link{print.RecipeWorkflow}()},
\code{\link{read_workflow}()},
\code{\link{reproduce_workflow}()},
\code{\link{save_workflow}()},
\code{\link{workflow}()},
\code{\link{workflow_from_list}()},
\code{\link{workflow_table}()}
}
\concept{workflows}
