% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provenance.R
\name{provenance}
\alias{provenance}
\alias{provenance.Survey}
\alias{provenance.data.table}
\alias{provenance.default}
\title{Get provenance from a survey or workflow result}
\usage{
provenance(x, ...)

\method{provenance}{Survey}(x, ...)

\method{provenance}{data.table}(x, ...)

\method{provenance}{default}(x, ...)
}
\arguments{
\item{x}{A \link{Survey} object or a \code{data.table} from \code{\link[=workflow]{workflow()}}.}

\item{...}{Additional arguments (unused).}
}
\value{
A \code{metasurvey_provenance} list, or \code{NULL} if no provenance
is available.
}
\description{
Returns the provenance metadata recording the full data lineage:
source file, step history with row counts, and environment info.
}
\examples{
svy <- Survey$new(
  data = data.table::data.table(id = 1:10, age = 20:29, w = 1),
  edition = "2023", type = "test", psu = NULL,
  engine = "data.table", weight = add_weight(annual = "w")
)
provenance(svy)

}
\seealso{
Other provenance: 
\code{\link{print.metasurvey_provenance}()},
\code{\link{print.metasurvey_provenance_diff}()},
\code{\link{provenance_diff}()},
\code{\link{provenance_to_json}()}
}
\concept{provenance}
