% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_tidy_api.R
\name{filter_workflows}
\alias{filter_workflows}
\title{Filter workflows by criteria}
\usage{
filter_workflows(
  survey_type = NULL,
  edition = NULL,
  recipe_id = NULL,
  certification_level = NULL
)
}
\arguments{
\item{survey_type}{Character survey type or \code{NULL} (default \code{NULL}).}

\item{edition}{Character edition or \code{NULL} (default \code{NULL}).}

\item{recipe_id}{Character recipe ID or \code{NULL} (default \code{NULL}). Find
workflows using this recipe.}

\item{certification_level}{Character certification level or \code{NULL}
(default \code{NULL}).}
}
\value{
List of matching RecipeWorkflow objects.
}
\description{
Filter workflows in the active backend by survey type, edition, recipe ID,
or certification level.
}
\examples{
set_workflow_backend("local", path = tempfile(fileext = ".json"))
ech_wf <- filter_workflows(survey_type = "ech")
length(ech_wf)

}
\seealso{
\code{\link{search_workflows}},
\code{\link{find_workflows_for_recipe}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{search_workflows}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
