% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{print_methods}
\alias{print_methods}
\alias{print.spectrum}
\alias{print.decon1}
\alias{print.decon2}
\alias{print.align}
\alias{print.spectra}
\alias{print.decons1}
\alias{print.decons2}
\alias{print.aligns}
\title{S3 Methods for Printing Metabodecon Objects}
\usage{
\method{print}{spectrum}(x, name = FALSE, ...)

\method{print}{decon1}(x, name = FALSE, ...)

\method{print}{decon2}(x, name = FALSE, ...)

\method{print}{align}(x, name = FALSE, ...)

\method{print}{spectra}(x, ...)

\method{print}{decons1}(x, ...)

\method{print}{decons2}(x, ...)

\method{print}{aligns}(x, ...)
}
\arguments{
\item{x}{The object to print.}

\item{name}{Logical. If TRUE, the name of the object is printed before the object.}

\item{...}{Not used. Only accepted to comply with generic \code{\link[base:print]{base::print()}}.}
}
\value{
NULL, called for side effect of printing to the standard output device.
}
\description{
S3 Methods for printing metabodecon objects as described in the \href{https://spang-lab.github.io/metabodecon/articles/}{Metabodecon Classes}.
}
\examples{
print(sim[[1]])
print(sim[[1]], name = TRUE)
print(sim)
decon <- deconvolute(sim[[1]], sfr = c(3.55, 3.35))
print(decon)
}
\author{
2024-2025 Tobias Schmidt: initial version.
}
