% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.medicalcoder_comorbidities_with_subconditions}
\alias{summary.medicalcoder_comorbidities_with_subconditions}
\title{Summaries of Comorbidities with Subconditions}
\usage{
\method{summary}{medicalcoder_comorbidities_with_subconditions}(object, ...)
}
\arguments{
\item{object}{a \code{medicalcoder_comorbidities_with_subconditions} object generated by calling
\code{\link[=comorbidities]{comorbidities()}} with \code{subconditions = TRUE}.  This is currently only
applicable to PCCC.}

\item{...}{additional parameters, not currently used}
}
\value{
a \code{data.frame} with five columns.
\enumerate{
\item \code{condition} the primary condition
\item \code{subcondition} the subcondition(s) within the \code{condition}.  There will be
a row where \code{subcondition} is \code{NA} which is used to report the \code{count} and
\code{percent_of_cohort} for the \code{condition} overall.
\item \code{count} the number of rows in \code{object} with the applicable \code{condition} and
\code{subcondition}.
\item \code{percent_of_cohort}: a numeric value within [0, 100] for the percent of
rows in \code{object} with the flagged \code{condition} and \code{subcondition}.
\item \code{percent_of_those_with_condition}: a numeric value within [0, 100] for the
subset of rows in \code{object} with the primary \code{condition} and the flagged
\code{subcondition}.  Will be \code{NA} for the primary \code{condition}.
}
}
\description{
Build summaries (counts and percentages) for each Pediatric Complex Chronic
Condition (PCCC) condition and subcondition.
}
\examples{
pccc_v3.1_subcondition_results <-
  comorbidities(data = mdcr,
                icd.codes = "code",
                id.vars = "patid",
                dx.var = "dx",
                method = "pccc_v3.1",
                flag.method = 'current',
                poa = 1,
                subconditions = TRUE)
summary(pccc_v3.1_subcondition_results)

}
\seealso{
\code{\link[=comorbidities]{comorbidities()}},
\code{vignette(topic = "pccc", package = "medicalcoder")}
}
