/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.trees.status;

import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;

public class ThetaStatus {
    protected int time;
    protected int duration;

    public final int getTime() {
        return this.time;
    }

    public final void setTime(int time) {
        this.time = time;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final void setDuration(int duration) {
        this.duration = duration;
    }

    protected void updateDuration(ThetaStatus lcs, ThetaStatus rcs) {
        this.setDuration(lcs.getDuration() + rcs.getDuration());
    }

    public void updateECT(ThetaStatus lcs, ThetaStatus rcs) {
        this.setTime(Math.max(rcs.getTime(), lcs.getTime() + rcs.getDuration()));
        this.updateDuration(lcs, rcs);
    }

    public void updateLST(ThetaStatus lcs, ThetaStatus rcs) {
        this.setTime(Math.min(lcs.getTime(), rcs.getTime() - lcs.getDuration()));
        this.updateDuration(lcs, rcs);
    }

    public void update(IVilimTree.TreeMode mode, ThetaStatus left, ThetaStatus right) {
        switch (mode) {
            case ECT: {
                this.updateECT(left, right);
                this.updateDuration(left, right);
                break;
            }
            case LST: {
                this.updateLST(left, right);
                this.updateDuration(left, right);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown tree mode.");
            }
        }
    }
}

