% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_devmodels.R
\name{plot_devmodels}
\alias{plot_devmodels}
\title{Plot fitted thermal performance curves}
\usage{
plot_devmodels(
  temp = NULL,
  dev_rate = NULL,
  fitted_parameters = NULL,
  species = NULL,
  life_stage = NULL
)
}
\arguments{
\item{temp}{a vector of temperatures used in the experiment.
It should have at least four different temperatures and must contain only numbers
without any missing values.}

\item{dev_rate}{a vector of estimated development rates corresponding to each temperature.
These rates are calculated as the inverse of the number of days to complete the transition
from the beginning of a certain life stage to the beginning of the following at each temperature.
It must be numeric and of the same length as \code{temp}.}

\item{fitted_parameters}{a \code{tibble} obtained with \code{\link[=fit_devmodels]{fit_devmodels()}},
including parameter names, estimates, standard errors, AICs, and
nls objects (fitted_models) using the \code{\link[nls.multstart:nls_multstart]{nls.multstart::nls_multstart()}} approach.}

\item{species}{optional a string of the target species that
will constitute the plot title. Must be of type "character".}

\item{life_stage}{optional a string of the target life stage that
will constitute the plot subtitle. Must be of type "character".}
}
\value{
A plot with predicted values (development rate) across temperatures
for models that have adequately converged using \code{\link[=fit_devmodels]{fit_devmodels()}} function.
It's a ggplot object, which can be assigned to a user-defined object.
}
\description{
Plot the predicted development rates across temperatures
based on fitted Thermal Performance Curves (TPCs)
for one or several models displayed in facets.
}
\examples{
data("aphid")

fitted_tpcs <- fit_devmodels(temp = aphid$temperature,
                             dev_rate = aphid$rate_value,
                             model_name = c("lactin2", "briere2", "mod_weibull"))

plot_devmodels(temp = aphid$temperature,
               dev_rate = aphid$rate_value,
               fitted_parameters = fitted_tpcs,
               species = "Brachycaudus schwartzi",
               life_stage = "Nymphs")
}
\references{
Angilletta, M.J., (2006). Estimating and comparing thermal performance curves.
\if{html}{\out{<i>}}J. Therm. Biol.\if{html}{\out{</i>}} 31: 541-545. (for model selection in TPC framework)

Padfield, D., O'Sullivan, H. and Pawar, S. (2021). \if{html}{\out{<i>}}rTPC\if{html}{\out{</i>}} and \if{html}{\out{<i>}}nls.multstart\if{html}{\out{</i>}}:
A new pipeline to fit thermal performance curves in \code{R}. \if{html}{\out{<i>}}Methods Ecol Evol\if{html}{\out{</i>}}. 12: 1138-1143.

Rebaudo, F., Struelens, Q. and Dangles, O. (2018). Modelling temperature-dependent
development rate and phenology in arthropods: The \code{devRate} package for \code{R}.
\if{html}{\out{<i>}}Methods Ecol Evol\if{html}{\out{</i>}}. 9: 1144-1150.

Satar, S. and Yokomi, R. (2002). Effect of temperature and host on development
of \if{html}{\out{<i>}}Brachycaudus schwartzi\if{html}{\out{</i>}} (Homoptera: Aphididae).
\if{html}{\out{<i>}}Ann. Entomol. Soc. Am.\if{html}{\out{</i>}} 95: 597-602.
}
\seealso{
\code{\link[=fit_devmodels]{fit_devmodels()}} for fitting Thermal Performance Curves to
development rate data, which is in turn based on \code{\link[nls.multstart:nls_multstart]{nls.multstart::nls_multstart()}}.
}
