% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_format.R
\name{manip_preformat}
\alias{manip_preformat}
\alias{to_named}
\alias{to_signed}
\alias{to_weighted}
\title{Modifying network formats}
\usage{
to_named(.data, names = NULL)

to_signed(.data, mark = NULL)

to_weighted(.data, measure = NULL)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{names}{Character vector of the node names. NULL by default.}

\item{mark}{A mark (logical vector) the length of the ties in the network.}

\item{measure}{A numeric vector (measure) that will be added as the tie
weights to the network.
If this is NULL, then the tie weights will be drawn from a
Poisson distribution with \eqn{\lambda = 4}.}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions add some format to manynet-consistent data.
\itemize{
\item \code{to_redirected()} reformats the direction of directed network data, flipping any existing direction.
\item \code{to_reciprocated()} reformats directed network data such that every directed tie is reciprocated.
\item \code{to_acyclic()} reformats network data to an acyclic graph.
\item \code{to_named()} reformats unlabelled network data to labelled network data
from a vector of names or random baby names.
\item \code{to_signed()} reformats unsigned network data to signed network data
with signs from a mark vector or at random.
}

If the format condition is not met,
for example \code{to_undirected()} is used on a network that is already undirected,
the network data is returned unaltered.
No warning is given so that these functions can be used to ensure conformance.

Unlike the \verb{as_*()} group of functions,
these functions always return the same class as they are given,
only transforming these objects' properties.
}
\details{
Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrrr}{
    \tab data.frame \tab igraph \tab matrix \tab network \tab tbl_graph \cr
   to_acyclic \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_directed \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_named \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_reciprocated \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_redirected \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_simplex \tab 0 \tab 1 \tab 1 \tab 0 \tab 1 \cr
}
}
\seealso{
Other modifications: 
\code{\link{manip_as}},
\code{\link{manip_correlation}},
\code{\link{manip_deformat}},
\code{\link{manip_direction}},
\code{\link{manip_from}},
\code{\link{manip_levels}},
\code{\link{manip_miss}},
\code{\link{manip_nodes}},
\code{\link{manip_paths}},
\code{\link{manip_permutation}},
\code{\link{manip_project}},
\code{\link{manip_reformat}},
\code{\link{manip_scope}},
\code{\link{manip_split}},
\code{\link{manip_ties}}
}
\concept{modifications}
