% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maidr.R
\name{save_html}
\alias{save_html}
\title{Save Interactive Plot as HTML File}
\usage{
save_html(plot = NULL, file = "plot.html", ...)
}
\arguments{
\item{plot}{A ggplot2 object or NULL for Base R auto-detection}

\item{file}{File path where to save the HTML file (e.g., "plot.html")}

\item{...}{Additional arguments passed to internal functions}
}
\value{
The file path where the HTML was saved (invisibly)
}
\description{
Save a ggplot2 or Base R plot as a standalone HTML file with interactive
MAIDR accessibility features.
}
\examples{
# ggplot2 example
library(ggplot2)
p <- ggplot(mtcars, aes(x = factor(cyl), y = mpg)) +
  geom_bar(stat = "identity")
\donttest{
maidr::save_html(p, tempfile(fileext = ".html"))
}

# Base R example (requires interactive session for function patching)
if (interactive()) {
  barplot(c(10, 20, 30), names.arg = c("A", "B", "C"))
  maidr::save_html(file = tempfile(fileext = ".html"))
}
}
