% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_exposure_QP.R
\name{optimize_exposure_QP}
\alias{optimize_exposure_QP}
\title{Quadratic programming optimization of signature activities}
\usage{
optimize_exposure_QP(spectrum, signatures)
}
\arguments{
\item{spectrum}{Mutational signature or mutational spectrum
as a numeric vector or single column data frame or matrix.}

\item{signatures}{Matrix or data frame of signatures from which to
reconstruct \code{spectrum}. Rows are mutation types and columns are
signatures. Should have column names for interpretable results. Cannot be a
vector because the column names are needed.}
}
\value{
A vector of exposures with names being the \code{colnames} from
  \code{signatures}.
}
\description{
Quadratic programming optimization of signature activities
}
\details{
Code adapted from \code{SignatureEstimation::decomposeQP} and
uses \code{\link[quadprog]{solve.QP}} in package \code{quadprog}.
}
\examples{
usigs <- matrix(c(0.2, 0.7, 0.1,
                  0.3, 0.6, 0.1,
                  0.1, 0.1, 0.8), nrow = 3)
colnames(usigs) <- c("u1", "u2", "u3")
tsig <- matrix(c(0.25, 0.65, 0.1), nrow = 3)
optimize_exposure_QP(tsig, usigs)
}
