% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{newey_west_tsls}
\alias{newey_west_tsls}
\title{Compute 2SLS parameters and robust standard errors based on Newey-West}
\usage{
newey_west_tsls(y, x, z, h)
}
\arguments{
\item{y}{Numeric vector.}

\item{x}{Numeric matrix.}

\item{z}{Numeric matrix.}

\item{h}{Integer.}
}
\value{
A list. The first element contains the estimated 2SLS parameters and the second element
the 2SLS-Newey-West covariance matrix of these parameters.  The third element contains the estimated functions, the fourth element
the unscaled covariance matrix, the fifth element the meat estimator and the last element the ordinary covariance matrix of the
point estimates.
}
\description{
Compute 2SLS parameters and robust standard errors based on Newey and West (1987).
Part of the function is based on the Matlab code by James P. LeSage.
}
\references{
Newey, W.K., and West, K.D. (1987). “A Simple, Positive-Definite, Heteroskedasticity and
Autocorrelation Consistent Covariance Matrix.” \emph{Econometrica}, 55, 703–708.
Wooldridge, J.M. (2002), Econometric Analysis of Cross Section and Panel Data, The MIT Press.
}
\keyword{internal}
