% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{samp2_elife}
\alias{samp2_elife}
\title{Sample lifetime from excess lifetime model}
\usage{
samp2_elife(
  n,
  scale,
  shape,
  family = c("exp", "gp", "gomp", "gompmake", "weibull", "extgp", "gppiece",
    "extweibull", "perks", "beard", "perksmake", "beardmake"),
  xcal,
  c1,
  c2
)
}
\arguments{
\item{n}{sample size}

\item{scale}{scale parameter(s)}

\item{shape}{shape parameter(s)}

\item{family}{string; choice of parametric family}

\item{xcal}{date at which individual reaches \code{u} years}

\item{c1}{date, first day of the sampling frame}

\item{c2}{date, last day of the sampling frame}
}
\value{
list with new birthdates (\code{xcal}), excess lifetime at \code{c1} (\code{ltrunc}),
excess lifetime above \code{u} (\code{dat}) and right-censoring indicator (\code{rightcens}).
}
\description{
Given parameters of a \code{elife} distribution, sampling window and
birth dates with excess lifetimes, sample new observations; excess lifetime
at \code{c1} are sampled from an exponential distribution, whereas
the birth dates are sampled from a jittered histogram-based distribution
The new excess lifetime above the threshold are right-censored if they exceed
\code{c2}.
}
\keyword{internal}
