% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{register_plotly}
\alias{register_plotly}
\title{Register a Plotly Component}
\usage{
register_plotly(
  session,
  registry,
  plotly_output_id,
  data_reactive,
  shared_id_column,
  event_types = c("plotly_click"),
  source = NULL,
  click_handler = NULL
)
}
\arguments{
\item{session}{Shiny session object}

\item{registry}{A link registry created by \code{\link[=create_link_registry]{create_link_registry()}}}

\item{plotly_output_id}{Character string: the outputId of your plotlyOutput}

\item{data_reactive}{Reactive expression returning the data frame for the plot}

\item{shared_id_column}{Character string: name of the ID column}

\item{event_types}{Character vector: plotly event types to listen for}

\item{source}{Character string: plotly source identifier for event tracking}

\item{click_handler}{Optional function: custom selection update handler.
Function signature: function(plot_proxy, selected_data, session)
where selected_data is the row from data_reactive() or NULL to clear selection.}
}
\value{
NULL (invisible). This function is called for its side effects.
}
\description{
\code{register_plotly} registers a Plotly component for linking with other components.
The default behavior uses plotly's built-in point selection highlighting, which
is simple and works reliably across all plot types.
}
\examples{
\donttest{
  # Create a mock session for the example
  session <- shiny::MockShinySession$new()

  # Create a registry
  registry <- create_link_registry(session)

  # Sample reactive data
  my_data <- shiny::reactive({
    data.frame(
      id = 1:5,
      name = c("A", "B", "C", "D", "E"),
      value = 11:15
    )
  })

  # Register a plotly component
  register_plotly(
    session,
    registry,
    plotly_output_id = "my_plot",
    data_reactive = my_data,
    shared_id_column = "id"
  )

  # Verify registration
  print(registry$get_components())
}
}
