% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example-weibull.R
\name{weibull_uncensored}
\alias{weibull_uncensored}
\alias{likelihood_exact_weibull}
\title{Weibull likelihood model (uncensored)}
\usage{
weibull_uncensored(ob_col)

likelihood_exact_weibull(ob_col)
}
\arguments{
\item{ob_col}{The name of the column in a data frame that
contains the observations.}
}
\value{
A \code{weibull_uncensored} likelihood model object
}
\description{
A likelihood model for exact (uncensored) observations from a Weibull
distribution. The model assumes that the observations are independent
and identically distributed (i.i.d.).

This is a reference implementation demonstrating how to satisfy the
likelihood_model concept with analytical derivatives. It provides:
\itemize{
\item \code{loglik.weibull_uncensored}: log-likelihood function
\item \code{score.weibull_uncensored}: score (gradient) function
\item \code{hess_loglik.weibull_uncensored}: Hessian of the log-likelihood
}

Analytical derivatives are 10-100x faster than the default numerical
differentiation via numDeriv.

This model may also be used as a contribution in
\code{likelihood_contr_model} for more complex models involving censoring.
}
