% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut.R
\name{cut_format}
\alias{cut_format}
\title{Convert Numeric to Factor, with custom formatting}
\usage{
cut_format(
  x,
  breaks,
  include.lowest = FALSE,
  right = TRUE,
  ordered_result = FALSE,
  ...,
  format_fun = format,
  sep = ", ",
  paren = c("(", "[", ")", "]")
)
}
\arguments{
\item{x}{a numeric vector which is to be converted to a factor by cutting.}

\item{breaks}{\verb{[numeric]}\cr
A vector of two or more unique cut points}

\item{include.lowest}{logical, indicating if an \sQuote{x[i]} equal to
    the lowest (or highest, for \code{right = FALSE}) \sQuote{breaks}
    value should be included.}

\item{right}{logical, indicating if the intervals should be closed on
    the right (and open on the left) or vice versa.}

\item{ordered_result}{logical: should the result be an ordered factor?}

\item{...}{Passed to \code{cut()}}

\item{format_fun}{\verb{[function(x): character]}\cr
A vectorized function that performs the desired formatting.  Default:
\code{\link[base:format]{base::format()}}}

\item{sep}{\verb{[character(1)]}\cr
The separator between lower and upper end of the interval. Default:
\code{", "}}

\item{paren}{\verb{[character(4)]}\cr
Opening and closing parentheses in two variants. Default:
\code{c("(", "[", ")", "]")}}
}
\description{
This is an enhanced version of \code{\link[base:cut]{base::cut()}} that allows a custom
formatting to be applied to the values.
}
\examples{
cut_format(runif(10), seq(0, 1, by = 0.25), format_fun = function(x) paste(x * 100, "\%"))
cut_format(runif(10), seq(0, 1, by = 0.25), paren = c("<", "{", ">", "}"))
}
\seealso{
\url{https://stackoverflow.com/q/14456371/946850}
}
