% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwidths.R
\name{inches_to_spaces}
\alias{inches_to_spaces}
\title{Conversion of inches to spaces.}
\usage{
inches_to_spaces(ins, fontspec, raw = FALSE, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{ins}{(\code{numeric})\cr Vector of widths in inches.}

\item{fontspec}{(\code{font_spec})\cr The font specification to use.}

\item{raw}{(\code{logical(1)})\cr Should the answer be returned unrounded
(\code{TRUE}), or rounded to the nearest reasonable value (\code{FALSE},
the default).}

\item{tol}{(\code{numeric(1)})\cr The numeric tolerance. Values
between an integer \code{n}, and \code{n+tol} will be returned
as \code{n}, rather than \code{n+1}, if \code{raw == FALSE}. Ignored
when \code{raw} is \code{TRUE}.}
}
\value{
The number of either fractional (\code{raw = TRUE}) or whole (\code{raw = FALSE})
spaces that will fit within \code{ins} inches in the specified font.
}
\description{
Conversion of inches to spaces.
}
