% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{cluster_permutation_tidiers}
\alias{cluster_permutation_tidiers}
\alias{tidy.timewise_statistics}
\alias{tidy.empirical_clusters}
\alias{tidy.null_cluster_dists}
\title{Tidiers for cluster permutation test objects}
\usage{
\method{tidy}{timewise_statistics}(x, ...)

\method{tidy}{empirical_clusters}(x, ...)

\method{tidy}{null_cluster_dists}(x, ...)
}
\arguments{
\item{x}{An object of class \verb{<timewise_statistics>}, \verb{<empirical_clusters>}, or \verb{<null_cluster_dists>}}

\item{...}{Unused}
}
\value{
A data frame
}
\description{
Tidiers for cluster permutation test objects
}
\examples{
\dontshow{if (julia_setup_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
\dontshow{
options("jlmerclusterperm.nthreads" = 2)
jlmerclusterperm_setup(cache_dir = tempdir(), verbose = FALSE)
julia_progress(show = FALSE)
}

library(dplyr, warn.conflicts = FALSE)

# Specification object
spec <- make_jlmer_spec(
  weight ~ 1 + Diet, filter(ChickWeight, Time <= 20),
  subject = "Chick", time = "Time"
)
spec

# Method for `<timewise_statistics>`
empirical_statistics <- compute_timewise_statistics(spec)
class(empirical_statistics)
tidy(empirical_statistics)

reset_rng_state()
null_statistics <- permute_timewise_statistics(spec, nsim = 100)
class(null_statistics)
tidy(null_statistics)

# Method for `<empirical_clusters>`
empirical_clusters <- extract_empirical_clusters(empirical_statistics, threshold = 2)
class(empirical_clusters)
tidy(empirical_clusters)

# Method for `<null_cluster_dists>`
null_cluster_dists <- extract_null_cluster_dists(null_statistics, threshold = 2)
class(null_cluster_dists)
tidy(null_cluster_dists)

\dontshow{
JuliaConnectoR::stopJulia()
}
}
\dontshow{\}) # examplesIf}
}
