% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdata_reg.bcbnp.R
\name{plotdata_reg.bcbnp}
\alias{plotdata_reg.bcbnp}
\title{Plot Meta-Regression Results from a BCBNP Model}
\usage{
plotdata_reg.bcbnp(
  object,
  covariate,
  title.plot = NULL,
  ci.color = "green",
  pi.color = "purple",
  mean.line.color = "magenta",
  pi.mean.line.color = "gray",
  point.color.unbiased = "blue",
  point.color.biased = "red",
  show_ci = TRUE,
  show_pi = TRUE,
  errorbar_width = 0.25,
  x.lab = covariate,
  y.lab = "Treatment Effect (TE)",
  legend.name = "Posterior Bias",
  size.legend.name = "1/seTE",
  label.unbiased = "Unbiased",
  label.biased = "Biased"
)
}
\arguments{
\item{object}{The output object from the bcbnp function.}

\item{covariate}{A character string specifying the single covariate
from the data to be plotted (e.g., `"baseline_va"`).}

\item{title.plot}{The title for the plot.}

\item{ci.color}{The color of the credible interval lines. Defaults to "green".}

\item{pi.color}{The color of the prediction interval lines. Defaults to "purple".}

\item{mean.line.color}{The color of the mean regression line. Defaults to "magenta".}

\item{pi.mean.line.color}{The color of the prediction interval median line. Defaults to "gray".}

\item{point.color.unbiased}{The color of unbiased points. Defaults to "blue".}

\item{point.color.biased}{The color of biased points. Defaults to "red".}

\item{show_ci}{A logical value indicating whether to show the credible interval. Defaults to `TRUE`.}

\item{show_pi}{A logical value indicating whether to show the prediction interval. Defaults to `TRUE`.}

\item{errorbar_width}{The width of the error bars. Defaults to `0.25`.}

\item{x.lab}{A character string for the x-axis label. Defaults to the covariate name.}

\item{y.lab}{A character string for the y-axis label. Defaults to "Treatment Effect (TE)".}

\item{legend.name}{A character string for the color legend title. Defaults to "Posterior Bias".}

\item{size.legend.name}{A character string for the size legend title. Defaults to "1/seTE".}

\item{label.unbiased}{A character string for the label of the unbiased group. Defaults to "Unbiased".}

\item{label.biased}{A character string for the label of the biased group. Defaults to "Biased".}
}
\value{
A ggplot object.
}
\description{
This function visualizes the results of a bias-corrected Bayesian nonparametric
meta-regression. It plots the raw data with error bars, colors points based on
the posterior probability of bias (I > 0.5), and adds the posterior mean
regression line, the credible interval for the true effects, and the
prediction interval for new observations, including its median line.
}
