#' iv.sensemakr: Sensitivity Analysis Tools for Instrumental Variable Estimates
#'
#' Implements a suite of sensitivity analysis tools for instrumental variable
#' estimates, as described in Cinelli and Hazlett (2025).
#'
#' The main functions of the package are \code{\link{iv_fit}}, which fits an IV
#' regression model using the Anderson-Rubin approach, and
#' \code{\link{sensemakr.iv_fit}}, which computes sensitivity analysis results
#' for objects of class \code{\link{iv_fit}}.
#'
#' @references
#'
#' Cinelli, C. and Hazlett, C. (2025), "An Omitted Variable Bias Framework for
#' Sensitivity Analysis of Instrumental Variables." Biometrika.
#' \doi{10.1093/biomet/asaf004}
#'
#' @keywords internal
"_PACKAGE"

