% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iunique.R
\name{i_dedup}
\alias{i_dedup}
\alias{idedup}
\title{Drop duplicated items from an iterator.}
\usage{
i_dedup(object, cmp = identical, ...)
}
\arguments{
\item{object}{an iterable object}

\item{cmp}{A function to use for comparison.}

\item{...}{passed along to \code{iteror(object, ...)}}
}
\value{
an iterator that skips over duplicate items from the
unterlying iterator.
}
\description{
Constructs an iterator that removes runs of repeated elements from the
underlying iterator. Order of the elements is maintained. Only the element
just seen is remembered for determining whether to drop.
}
\details{
Originated as \code{itertools2::iunique_lastseen}.
\code{object}.
}
\examples{
it <- i_chain(rep(1,4), rep(2, 5), 4:7, 2)
it_i_unique <- idedup(it)
as.list(it_i_unique) # 1 2 4 5 6 7 2

it2 <- iteror(c('a', 'a', "A", 'a', 'a', "V"))
i_dedupe <- idedup(it2)
as.list(idedup) # a A a V

}
\seealso{
i_rle
}
