% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_outliers.R
\name{remove_outliers}
\alias{remove_outliers}
\title{Remove outliers using mixed models}
\usage{
remove_outliers(data, formula, drop_na = FALSE, plot_diag = FALSE)
}
\arguments{
\item{data}{Experimental design data frame with the factors and traits.}

\item{formula}{mixed model formula.}

\item{drop_na}{drop NA values from the data.frame}

\item{plot_diag}{Diagnostic plot based in the raw and clean data}
}
\value{
list. 1. Table with date without outliers. 2. The outliers in the
dataset.
}
\description{
Use the method M4 in Bernal Vasquez (2016). Bonferroni Holm test to judge
residuals standardized by the re scaled MAD (BH MADR).
}
\details{
Function to remove outliers in MET experiments
}
\examples{

library(inti)

rmout <- potato \%>\%
  remove_outliers(data = .
  , formula = stemdw ~ 0 + (1|bloque) + treat*geno
  , plot_diag = FALSE
  , drop_na = FALSE
  )

rmout
  
}
\references{
Bernal Vasquez, Angela Maria, et al. “Outlier Detection Methods for
Generalized Lattices: A Case Study on the Transition from ANOVA to REML.”
Theoretical and Applied Genetics, vol. 129, no. 4, Apr. 2016.
}
