% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{getDimPage}
\alias{getDimPage}
\title{Get dimension of the page available for content 
for standard Word report or PowerPoint presentation.}
\usage{
getDimPage(
  type = c("width", "height"),
  landscape = (style == "presentation"),
  margin = 1,
  pageDim = NULL,
  style = "report"
)
}
\arguments{
\item{type}{Character vector with dimension of interest, among: 
'width', 'height', multiple are possible.
By default: \code{c("width", "height")}}

\item{landscape}{Logical, if TRUE the table is presented in landscape
format. \cr
By default: TRUE for \code{style}: 'report',
FALSE for \code{style}: 'presentation'.}

\item{margin}{Margin in the document in inches, 1 by default.}

\item{pageDim}{(optional) Numeric vector of length 2 with 
page width and height in inches in portrait format,
in case page dimensions differ from the default
implemented report/presentation.
These dimensions should include the margins.}

\item{style}{String with table style, either 'report' (by default, a4 format) 
or 'presentation'}
}
\value{
numeric vector with dimension of interest,
in the same order as specified via the \code{type}
parameter.
}
\description{
Report is in A4 and presentation dimensions extracted from
PowerPoint.
The returned dimensions are the page dimensions without the margins.
}
\examples{
## get part of the page available for content
# report A4 portrait format:
getDimPage(type = "width")
getDimPage(type = "height")
# report A4 landscape format:
getDimPage(type = "width", landscape = TRUE)
getDimPage(type = "height", landscape = TRUE)
# Note that the layout is by default set to 'landscape'
getDimPage(type = "width", style = "presentation")
getDimPage(type = "height", style = "presentation")
# custom dimensions: A3 format
getDimPage(type = "width", pageDim = c(11.7, 16.5))
# increase margin
getDimPage(type = "width", margin = 1.5)
# get both dimensions at once
getDimPage(type = c("width", "height"))
# get dimensions of the full page (including margins)
getDimPage(type = c("width", "height"), style = "report", margin = 0)
getDimPage(type = c("width", "height"), style = "presentation", margin = 0)
}
\author{
Laure Cougnaud
}
