% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{isoblur}
\alias{isoblur}
\title{Blur image isotropically.}
\usage{
isoblur(im, sigma, neumann = TRUE, gaussian = TRUE, na.rm = FALSE)
}
\arguments{
\item{im}{an image}

\item{sigma}{Standard deviation of the blur (positive)}

\item{neumann}{If true, use Neumann boundary conditions, Dirichlet otherwise  (default true, Neumann)}

\item{gaussian}{Use a Gaussian filter (actually van Vliet-Young). Default: 0th-order Deriche filter.}

\item{na.rm}{if TRUE, ignore NA values. Default FALSE, in which case the whole image is NA if one of the values is NA (following the definition of the Gaussian filter)}
}
\description{
Blur image isotropically.
}
\examples{
\dontshow{cimg.limit.openmp()}
isoblur(boats,3) \%>\% plot(main="Isotropic blur, sigma=3")
isoblur(boats,10) \%>\% plot(main="Isotropic blur, sigma=10")
}
\seealso{
deriche,vanvliet,inpaint,medianblur
}
