% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{biconnected_components}
\alias{biconnected_components}
\title{Biconnected components}
\usage{
biconnected_components(graph)
}
\arguments{
\item{graph}{The input graph. It is treated as an undirected graph, even if
it is directed.}
}
\value{
A named list with three components:
\describe{
\item{no}{
Numeric scalar, an integer giving the number of biconnected components in the graph.
}
\item{tree_edges}{
The components themselves, a list of numeric vectors.
Each vector is a set of edge ids giving the edges in a biconnected component.
These edges define a spanning tree of the component.
}
\item{component_edges}{
A list of numeric vectors. It gives all edges in the components.
}
\item{components}{
A list of numeric vectors, the vertices of the components.
}
\item{articulation_points}{
The articulation points of the graph. See \code{\link[=articulation_points]{articulation_points()}}.
}
}
}
\description{
Finding the biconnected components of a graph
}
\details{
A graph is biconnected if the removal of any single vertex (and its adjacent
edges) does not disconnect it.

A biconnected component of a graph is a maximal biconnected subgraph of it.
The biconnected components of a graph can be given by the partition of its
edges: every edge is a member of exactly one biconnected component. Note
that this is not true for vertices: the same vertex can be part of many
biconnected components.
}
\examples{

g <- disjoint_union(make_full_graph(5), make_full_graph(5))
clu <- components(g)$membership
g <- add_edges(g, c(which(clu == 1), which(clu == 2)))
bc <- biconnected_components(g)
}
\seealso{
\code{\link[=articulation_points]{articulation_points()}}, \code{\link[=components]{components()}},
\code{\link[=is_connected]{is_connected()}}, \code{\link[=vertex_connectivity]{vertex_connectivity()}}

Connected components
\code{\link{articulation_points}()},
\code{\link{component_distribution}()},
\code{\link{decompose}()},
\code{\link{is_biconnected}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{components}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Structural.html#igraph_biconnected_components}{\code{biconnected_components()}}.}

