% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{callaway.traits.game}
\alias{callaway.traits.game}
\title{Graph generation based on different vertex types}
\usage{
callaway.traits.game(
  nodes,
  types,
  edge.per.step = 1,
  type.dist = rep(1, types),
  pref.matrix = matrix(1, types, types),
  directed = FALSE
)
}
\arguments{
\item{nodes}{The number of vertices in the graph.}

\item{types}{The number of different vertex types.}

\item{edge.per.step}{The number of edges to add to the graph per time step.}

\item{type.dist}{The distribution of the vertex types. This is assumed to be
stationary in time.}

\item{pref.matrix}{A matrix giving the preferences of the given vertex
types. These should be probabilities, i.e. numbers between zero and one.}

\item{directed}{Logical constant, whether to generate directed graphs.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{callaway.traits.game()} was renamed to \code{\link[=sample_traits_callaway]{sample_traits_callaway()}} to create a more
consistent API.
}
\keyword{internal}
