% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{alpha.centrality}
\alias{alpha.centrality}
\title{Find Bonacich alpha centrality scores of network positions}
\usage{
alpha.centrality(
  graph,
  nodes = V(graph),
  alpha = 1,
  loops = FALSE,
  exo = 1,
  weights = NULL,
  tol = 1e-07,
  sparse = TRUE
)
}
\arguments{
\item{graph}{The input graph, can be directed or undirected. In undirected
graphs, edges are treated as if they were reciprocal directed ones.}

\item{nodes}{Vertex sequence, the vertices for which the alpha centrality
values are returned. (For technical reasons they will be calculated for all
vertices, anyway.)}

\item{alpha}{Parameter specifying the relative importance of endogenous
versus exogenous factors in the determination of centrality. See details
below.}

\item{loops}{Whether to eliminate loop edges from the graph before the
calculation.}

\item{exo}{The exogenous factors, in most cases this is either a constant --
the same factor for every node, or a vector giving the factor for every
vertex. Note that too long vectors will be truncated and too short vectors
will be replicated to match the number of vertices.}

\item{weights}{A character scalar that gives the name of the edge attribute
to use in the adjacency matrix. If it is \code{NULL}, then the
\sQuote{weight} edge attribute of the graph is used, if there is one.
Otherwise, or if it is \code{NA}, then the calculation uses the standard
adjacency matrix.}

\item{tol}{Tolerance for near-singularities during matrix inversion, see
\code{\link[=solve]{solve()}}.}

\item{sparse}{Logical scalar, whether to use sparse matrices for the
calculation. The \sQuote{Matrix} package is required for sparse matrix
support}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{alpha.centrality()} was renamed to \code{\link[=alpha_centrality]{alpha_centrality()}} to create a more
consistent API.
}
\keyword{internal}
