% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{ibge_explorer}
\alias{ibge_explorer}
\title{Interactive aggregate explorer}
\usage{
ibge_explorer(launch.browser = TRUE)
}
\arguments{
\item{launch.browser}{Logical or function. If \code{TRUE}, opens the app in
the default browser. If \code{FALSE}, opens in the RStudio Viewer pane
(default). You can also pass a function such as \code{\link[shiny:viewer]{shiny::paneViewer()}}.}
}
\value{
This function is called for its side effect (launching the app).
Returns the value of \code{\link[shiny:runApp]{shiny::runApp()}} invisibly.
}
\description{
Launches a Shiny app for browsing and filtering the full catalog of IBGE
aggregates. The app displays value boxes with summary counts, a searchable
table with column-level filters, and lets you filter by survey or search
aggregate names.
}
\details{
Clicking a row shows a notification with the aggregate ID and the
corresponding \code{ibge_metadata()} call. A CSV download button is also
available.
}
\examples{
\dontrun{
# Open in RStudio Viewer
ibge_explorer(launch.browser = FALSE)

# Open in browser
ibge_explorer()
}

}
