% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agregados.R
\name{ibge_aggregates}
\alias{ibge_aggregates}
\title{List IBGE aggregates}
\usage{
ibge_aggregates(
  period = NULL,
  subject = NULL,
  classification = NULL,
  periodicity = NULL,
  level = NULL
)
}
\arguments{
\item{period}{Period of interest, e.g. \code{"P5[202001]"} (monthly),
\code{"P10[20201]"} (quarterly).}

\item{subject}{Numeric subject code (e.g. \code{70} for animal slaughter).
Use \code{\link[=ibge_subjects]{ibge_subjects()}} to look up codes.}

\item{classification}{Numeric classification code.}

\item{periodicity}{Periodicity code: \code{"P5"} (monthly), \code{"P10"}
(quarterly), \code{"P13"} (annual), etc.}

\item{level}{Geographic level: \code{"N1"} (Brazil), \code{"N2"} (region), \code{"N3"}
(state), \code{"N6"} (municipality), etc.}
}
\value{
A \link[tibble:tibble]{tibble} with columns:
\code{survey_id}, \code{survey_name}, \code{aggregate_id}, \code{aggregate_name}
}
\description{
Retrieves the set of available aggregates (tables), grouped by survey.
Each aggregate corresponds to a SIDRA table. Results are cached in memory
per unique combination of parameters, so repeated calls with the same
filters are instant.
}
\examples{
\dontrun{
ibge_aggregates()
ibge_aggregates(periodicity = "P5")
ibge_aggregates(level = "N6")
}

}
