% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_download_dashboard_metadata.R
\name{ifcb_download_dashboard_metadata}
\alias{ifcb_download_dashboard_metadata}
\title{Download metadata from the IFCB Dashboard API}
\usage{
ifcb_download_dashboard_metadata(base_url, dataset_name = NULL, quiet = FALSE)
}
\arguments{
\item{base_url}{Character. Base URL to the IFCB Dashboard (e.g. "https://ifcb-data.whoi.edu/").}

\item{dataset_name}{Optional character. Dataset slug (e.g. "mvco") to retrieve metadata for a specific dataset.
If NULL, all available metadata are downloaded.}

\item{quiet}{Logical. If TRUE, suppresses progress messages. Default is FALSE.}
}
\value{
A data frame containing the exported metadata.
}
\description{
Download metadata from the IFCB Dashboard API
}
\examples{
\donttest{
  # Download metadata for a specific dataset
  metadata_mvco <- ifcb_download_dashboard_metadata("https://ifcb-data.whoi.edu/",
                                                    dataset_name = "mvco",
                                                    quiet = TRUE)

  # Print result as tibble
  print(metadata_mvco)
}

}
\seealso{
\code{\link[=ifcb_download_dashboard_data]{ifcb_download_dashboard_data()}} to download data from the IFCB Dashboard API.

\code{\link[=ifcb_list_dashboard_bins]{ifcb_list_dashboard_bins()}} to retrieve list of available bins from the IFCB Dashboard API.
}
