% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesize.R
\name{complement_test}
\alias{complement_test}
\title{Complement a Hypothesis Test (NOT)}
\usage{
complement_test(test)
}
\arguments{
\item{test}{A \code{hypothesis_test} object.}
}
\value{
A \code{hypothesis_test} object with \code{"complemented_test"} prepended
to the class vector. The original class hierarchy is preserved.
\describe{
\item{original_pval}{The pre-complement p-value}
\item{original_test}{The input test object}
}
}
\description{
Negates a hypothesis test by transforming its p-value: \eqn{p \to 1 - p}.
The complement test rejects when the original test fails to reject.
}
\details{
The complement is the NOT operation in the Boolean algebra of hypothesis
tests. Together with \code{\link[=intersection_test]{intersection_test()}} (AND) and \code{\link[=union_test]{union_test()}} (OR),
it forms a complete algebra where De Morgan's laws hold by construction.
}
\section{Connection to Equivalence Testing}{

If the original test checks "is \eqn{\theta} different from
\eqn{\theta_0}?" (rejecting when the difference is large), the
complement checks "is \eqn{\theta} close to \eqn{\theta_0}?"
(rejecting when the difference is small). This connects to the
Two One-Sided Tests (TOST) procedure used in bioequivalence studies.
}

\section{Algebraic Properties}{

\itemize{
\item Double complement is identity:
\code{complement_test(complement_test(t))} has the same p-value as \code{t}
\item De Morgan's law:
\code{union_test(a, b) = complement_test(intersection_test(complement_test(a), complement_test(b)))}
}
}

\examples{
w <- wald_test(estimate = 3.0, se = 1.0)
pval(w)                  # small
pval(complement_test(w)) # large

# Double complement recovers the original
pval(complement_test(complement_test(w))) == pval(w)

}
\seealso{
\code{\link[=intersection_test]{intersection_test()}}, \code{\link[=union_test]{union_test()}}
}
