% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fbio.R
\name{get_fbio}
\alias{get_fbio}
\title{Retrieve or calculate fraction of chemical absorbed from the gut}
\usage{
get_fbio(
  parameters = NULL,
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  Caco2.Pab.default = 1.6,
  Caco2.Fgut = TRUE,
  Caco2.Fabs = TRUE,
  overwrite.invivo = FALSE,
  keepit100 = FALSE,
  suppress.messages = FALSE,
  ...
)
}
\arguments{
\item{parameters}{A list of the parameters (Caco2.Pab, Funbound.Plasma, Rblood2plasma,
Clint, BW, Qsmallintestine, Fabs, Fgut) used in the calculation, either supplied by user
or calculated in parameterize_steady_state.}

\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- the 
chemical must be identified by either CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  the 
chemical must be identified by either CAS, name, or DTXISD}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
-- the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{Caco2.Pab.default}{sets the default value for  Caco2.Pab if Caco2.Pab is 
unavailable.}

\item{Caco2.Fgut}{= TRUE uses Caco2.Pab to calculate  fgut.oral, otherwise 
fgut.oral = \code{Fgut}.}

\item{Caco2.Fabs}{= TRUE uses Caco2.Pab to calculate
fabs.oral, otherwise fabs.oral = \code{Fabs}.}

\item{overwrite.invivo}{= TRUE overwrites Fabs and Fgut in vivo values from 
literature with Caco2 derived values if available.}

\item{keepit100}{TRUE overwrites Fabs and Fgut with 1 (i.e. 100 percent) 
regardless of other settings.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{...}{Additional parameters passed to parameterize function if 
parameters is NULL.}
}
\description{
This function checks for chemical-specific in vivo measurements of the 
fraction absorbed from the
gut in the \code{\link{chem.physical_and_invitro.data}} table. If in vivo
data are unavailable (or \code{keepit100 == TRUE}) we attempt to use 
in vitro Caco-2 membrane permeability to predict the fractions according to
\code{\link{calc_fbio.oral}}.
}
\seealso{
\code{\link{calc_fbio.oral}}
}
\author{
Greg Honda and John Wambaugh
}
\keyword{Parameter}
\keyword{oral_bioavailability}
