% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{summary_diag}
\alias{summary_diag}
\title{Summary Statistics for Emulators}
\usage{
summary_diag(emulator, validation, verbose = interactive())
}
\arguments{
\item{emulator}{The emulator to test}

\item{validation}{The validation set, consisting of points and output(s)}

\item{verbose}{Should statistics be printed out?}
}
\value{
Whether the observed value lies within 3-sigma of the expected value.
}
\description{
Generates measures for emulator quality
}
\details{
A couple of summary statistics can be generated for emulators, based on their
prediction errors on a validation set. This function produces the test statistic
for a comparison to a relevant chi-squared distribution, and the similar test
statistic for an F-distribution. In both cases, the expectation and standard
deviation of the underlying distribution are also provided.

The output of this function is a logical vector stating whether the derived
value lies within 3-sigma of the expected value. In systems where errors are
expected to be correlated, higher weight should be given to the Mahalanobis
measure than the chi-squared measure. Any anomalous results can be investigated
in more depth using the \code{\link{individual_errors}} function.
}
\examples{
 summary_diag(SIREmulators$ems$nR, SIRSample$validation)
}
\references{
Bastos & O'Hagan (2009) <doi:10.1198/TECH.2009.08019>
}
\seealso{
Other diagnostic functions: 
\code{\link{analyze_diagnostic}()},
\code{\link{classification_diag}()},
\code{\link{comparison_diag}()},
\code{\link{get_diagnostic}()},
\code{\link{individual_errors}()},
\code{\link{residual_diag}()},
\code{\link{standard_errors}()},
\code{\link{validation_diagnostics}()}
}
\concept{diagnostic functions}
