% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand.R
\name{rcat}
\alias{rcat}
\title{Random generation for categorical distribution}
\usage{
rcat(n, prob)
}
\arguments{
\item{n}{Number of random observations to draw.}

\item{prob}{A matrix of probabilities where rows correspond to observations
and columns correspond to categories.}
}
\value{
A vector of random samples from the categorical distribution. The length of the sample is
determined by n. The numerical arguments other than n are recycled so that the number of samples is
equal to n.
}
\description{
Draw random samples from a categorical distribution given a matrix of probabilities.
\code{rcat} is vectorized and written in C++ for speed.
}
\examples{
p <- c(.2, .5, .3)
n <- 10000
pmat <- matrix(rep(p, n), nrow = n, ncol = length(p), byrow = TRUE)

# rcat
set.seed(100)
ptm <- proc.time()
samp1 <- rcat(n, pmat)
proc.time() - ptm
prop.table(table(samp1))

# rmultinom from base R 
set.seed(100)
ptm <- proc.time()
samp2 <- t(apply(pmat, 1, rmultinom, n = 1, size = 1))
samp2 <- apply(samp2, 1, function(x) which(x == 1))
proc.time() - ptm
prop.table(table(samp2))
}
