% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/river_plot.R
\name{riverPlot}
\alias{riverPlot}
\title{Create an alluvial plot}
\usage{
riverPlot(
  df,
  title = NULL,
  fillColIndex = 2,
  curveType = "sigmoid",
  alpha = 0.8,
  strataFill = "lightgoldenrod1",
  labelSize = 3,
  axisTextSize = 12,
  axisTitleSize = 12,
  viridisPal = "turbo",
  ...
)
}
\arguments{
\item{df}{A data frame with two categorical columns and a numeric column.}

\item{title}{Plot title.}

\item{fillColIndex}{Index of column used for coloring the alluvia.}

\item{curveType}{Curve type.}

\item{alpha}{Opaqueness level for the colors of the alluvia.}

\item{strataFill}{Color used for the strata.}

\item{labelSize}{Size of labels of strata elements.}

\item{axisTextSize}{Axis text size.}

\item{axisTitleSize}{Axis title size.}

\item{viridisPal}{Viridis palette.}

\item{...}{Other arguments passed to \code{centerTitle}.}
}
\value{
An object of class \code{gg}.
}
\description{
This function creates an alluvial plot.
}
\examples{
df <- data.frame(x = sample(c('a','b', 'c', 'd', 'e', 'f'), 20,
replace=TRUE),
y = sample(c('p','q', 'r', 's', 't', 'u', 'v', 'w'), 20,
replace=TRUE),
z = runif(20, 1, 3))
riverPlot(df)

}
