% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile_plot.R
\name{correlationPlot}
\alias{correlationPlot}
\title{Plot a correlation matrix}
\usage{
correlationPlot(mat, title = NULL, legendTitle = "Correlation", ...)
}
\arguments{
\item{mat}{A numeric matrix or data frame.}

\item{title}{Plot title.}

\item{legendTitle}{Legend title.}

\item{...}{Additional parameters passed to tilePlot.}
}
\value{
An object of class \code{gg}.
}
\description{
This function plots a correlation matrix.
}
\details{
A thin wrapper around \code{tilePlot}.
}
\examples{
mat <- matrix(runif(100, -1, 1), nrow=10)
colnames(mat) <- paste0('I', seq(10))
mat <- round(cor(mat), 2)
correlationPlot(mat)

}
