% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heaping_indices.R
\name{noumbissi}
\alias{noumbissi}
\title{Noumbissi's Digit Heaping Index}
\usage{
noumbissi(
  x,
  digit = 0,
  ageMin = 20 + digit,
  ageMax = ageMin + 30,
  weight = NULL
)
}
\arguments{
\item{x}{numeric vector of individual ages.}

\item{digit}{integer (0-9) specifying which terminal digit to evaluate
(default 0).}

\item{ageMin}{minimum age to include (default 20 + digit).}

\item{ageMax}{maximum age to include (default ageMin + 30).}

\item{weight}{optional numeric vector of sampling weights.}
}
\value{
A single numeric value representing Noumbissi's index for the
  specified digit.
}
\description{
Noumbissi's method improves on Whipple's method by extending its basic
principle to all ten digits. It compares the count of ages ending in a
specific digit to the count in 5-year age groups centered on that digit.
}
\details{
Calculate Noumbissi's index for a specific terminal digit.


The index compares the number of persons reporting ages ending in a
specific digit to one-fifth of the population in the 5-year age groups
centered on those ages.

Interpretation:
\itemize{
  \item 1.0: no preference for the digit
  \item >1.0: preference (attraction) to the digit
  \item <1.0: avoidance of the digit
}
}
\examples{
# No heaping
set.seed(42)
age_uniform <- sample(20:70, 10000, replace = TRUE)
noumbissi(age_uniform, digit = 0)  # Should be close to 1
noumbissi(age_uniform, digit = 5)  # Should be close to 1

# Heaping on digit 0
age_heap0 <- sample(seq(20, 70, by = 10), 5000, replace = TRUE)
noumbissi(age_heap0, digit = 0)  # Should be > 1

}
\references{
Noumbissi, A. (1992). L'indice de Whipple modifie: une application aux
donnees du Cameroun, de la Suede et de la Belgique. \emph{Population},
\strong{47}(4), 1038-1041.
}
\seealso{
\code{\link{spoorenberg}} for Total Modified Whipple index,
  \code{\link{whipple}} for original Whipple's index.

Other heaping indices: 
\code{\link{bachi}()},
\code{\link{coale_li}()},
\code{\link{heaping_indices}()},
\code{\link{jdanov}()},
\code{\link{kannisto}()},
\code{\link{myers}()},
\code{\link{spoorenberg}()},
\code{\link{whipple}()}
}
\author{
Matthias Templ
}
\concept{heaping indices}
