% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_uncertainty.R
\name{summarize_uncertainty}
\alias{summarize_uncertainty}
\title{Get Monte Carlo confidence intervals}
\usage{
summarize_uncertainty(output_attribute, n_sim, seed = NULL)
}
\arguments{
\item{output_attribute}{\code{variable} in which the output of a \code{healthiar::attribute_...()} function call are stored.}

\item{n_sim}{\code{numeric value} indicating the number of simulations to be performed.}

\item{seed}{\code{numeric value} for fixing the randomization. Based on it, each geographic unit is assigned a different. If empty, 123 is used as the base seed per default. The function preserves and restores the user's original random seed (if set prior to calling the function) upon function completion.}
}
\value{
This function returns a \code{list} containing:

1) \code{uncertainty_main} (\code{tibble}) containing the \code{numeric}
summary uncertainty central estimate and corresponding lower and upper confidence intervals
for the attributable health impacts obtained through Monte Carlo simulation;

2) \code{uncertainty_detailed} (\code{list}) containing detailed (and interim) results.
\itemize{
 \item \code{impact_by_sim} (\code{tibble}) containing the results for each simulation
 \item \code{uncertainty_by_geo_id_micro} (\code{tibble}) containing results for each geographic unit under analysis (specified in \code{geo_id_micro} argument in the preceding \code{attribute_health} call)
 }
 The two results elements are added to the existing output.
}
\description{
This function obtains a summary of uncertainty
(based on central, lower and upper estimates of at least one input variable)
using a Monte Carlo simulation.

Input variables that will be processed are:
\itemize{
  \item{relative_risk (\code{rr_...})}
  \item{exposure (\code{exp_...})}
  \item{cutoff (\code{cutoff_...})}
  \item{baseline health data (\code{bhd_...})}
  \item{disability weight (\code{dw_...})}
  \item{duration (\code{duration_...})}
  }
}
\details{
\strong{Function arguments}
\code{seed}
If the \code{seed} argument is specified then the \code{parallel} package
is used to generate independent L’Ecuyer random number streams.
One stream is allocated per variable (or per variable–geography combination, as needed),
ensuring reproducible and independent random draws across variables and scenarios.


\strong{Methodology}

This function summarizes the uncertainty of the attributable health impacts
(i.e.a single confidence interval instead of many combinations).
For this purpose, it applies
a Monte Carlo simulation \insertCite{Robert2004_book,Rubinstein2016_book}{healthiar}.

Detailed information about the methodology (including equations)
is available in the package vignette.
More specifically, see chapters:
\itemize{
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#monte-carlo-simulation}{Monte Carlo simulation}}
}
\examples{
# Goal: obtain summary uncertainty for an existing attribute_health() output
# First create an assessment
attribute_health_output <- attribute_health(
  erf_shape = "log_linear",
  rr_central = 1.369,
  rr_lower = 1.124,
  rr_upper = 1.664,
  rr_increment = 10,
  exp_central = 8.85,
  exp_lower = 8,
  exp_upper = 10,
  cutoff_central = 5,
  bhd_central = 30747,
  bhd_lower = 28000,
  bhd_upper = 32000
)
# Then run Monte Carlo simulation
results <- summarize_uncertainty(
  output_attribute = attribute_health_output,
  n_sim = 100
)
results$uncertainty_main$impact # Central, lower and upper estimates


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
  \item Upstream:
    \code{\link{attribute_health}}, \code{\link{attribute_lifetable}},
    \code{\link{compare}}
}
}
\author{
Alberto Castro & Axel Luyten
}
