% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Compare the attributable health impacts between two scenarios}
\usage{
compare(
  output_attribute_scen_1,
  output_attribute_scen_2,
  approach_comparison = "delta"
)
}
\arguments{
\item{output_attribute_scen_1}{Scenario 1 as in the output of attribute()}

\item{output_attribute_scen_2}{Scenario 2 as in the output of attribute()}

\item{approach_comparison}{\code{String} showing the method of comparison. Options: "delta" or "pif".}
}
\value{
This function returns a \code{list} containing:

1) \code{health_main} (\code{tibble}) containing the main results from the comparison;
\itemize{
 \item \code{impact} (\code{numeric} column) difference in attributable health burden/impact between scenario 1 and 2
 \item \code{impact_scen_1} (\code{numeric} column) attributable health impact of scenario 1
 \item \code{impact_scen_2} (\code{numeric} column) attributable health impact of scenario 2
 \item And many more
 }

2) \code{health_detailed} (\code{list}) containing detailed (and interim) results from the comparison.
\itemize{
 \item \code{results_raw} (\code{tibble}) containing comparison results for each combination of input uncertainty for both scenario 1 and 2
 \item \code{results_by_geo_id_micro} (\code{tibble}) containing comparison results for each geographic unit under analysis (specified in \code{geo_id_micro} argument)
 \item \code{results_by_geo_id_macro} (\code{tibble}) containing comparison results for each aggregated geographic unit under analysis (specified in \code{geo_id_macro} argument))
 \item \code{input_table} (\code{list}) containing the inputs to each relevant argument for both scenario 1 and 2
 \item \code{input_args} (\code{list}) containing all the argument inputs for both scenario 1 and 2 used in the background
 \item \code{scen_1} (\code{tibble}) containing results for scenario 1
 \item \code{scen_2} (\code{tibble}) containing results for scenario 2
 }
}
\description{
This function calculates the health impacts between two scenarios
(e.g. before and after a intervention in a health impact assessments) using either the delta or pif approach.
}
\details{
\strong{Methodology}
This function compares the attributable health impacts in scenario 1 with scenario 2.
It can use two approaches:
\itemize{
 \item{Delta: Subtraction of health impacts in the two scenarios (two PAF) \insertCite{WHO2014_book}{healthiar}}
 \item{Potential impact fraction (PIF): Single PIF for both scenarios \insertCite{WHO2003_report,Murray2003_spbm,Askari2020_ijph}{healthiar}}}


Detailed information about the methodology (including equations)
is available in the package vignette.
More specifically, see chapters:
\itemize{
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#comparison-of-two-health-scenarios}{comparison of two health scenarios}}


\strong{Specifications of the comparison approach}

Please, note that the PIF comparison approach assumes same baseline health data for scenario 1 and 2
(e.g. comparison of two scenarios at the same time point).
With the delta comparison approach, the difference between two scenarios is obtained by subtraction.
The delta approach is suited for all comparison cases,
allowing a comparison of a situation now with a situation in the future.


IMPORTANT: If your aim is to quantify health impacts from a policy intervention,
be aware that you should use the same year of analysis
and therefore same health baseline data
in both scenarios. The only variable that should change is the exposure
(as a result of the intervention).


\strong{Comparing DALY}

If you want to use \code{compare()} DALY with \code{daly()},
do not enter the output of \code{daly()} in \code{compare()}.
Instead, follow these steps:

1) use \code{compare()} for YLL and YLD separately

2) use \code{daly()} inserting the output of both compare()

Alternatively, you can use \code{attribute_health}
to quantify DALY entering DALY in the argument \code{bhd_central}
and then use \code{compare()}
}
\examples{
# Goal: comparison of two scenarios with delta approach
scenario_A <- attribute_health(
  exp_central = 8.85,   # EXPOSURE 1
  cutoff_central = 5,
  bhd_central = 25000,
  approach_risk = "relative_risk",
  erf_shape = "log_linear",
  rr_central = 1.118,
  rr_increment = 10
)
scenario_B <- attribute_health(
  exp_central = 6,     # EXPOSURE 2
  cutoff_central = 5,
  bhd_central = 25000,
  approach_risk = "relative_risk",
  erf_shape = "log_linear",
  rr_central = 1.118,
  rr_increment = 10
)
results <- compare(
approach_comparison = "delta",
output_attribute_scen_1 = scenario_A,
output_attribute_scen_2 = scenario_B
)
# Inspect the difference, stored in the \code{impact} column
results$health_main |>
  dplyr::select(impact, impact_scen_1, impact_scen_2) |>
  print()

# Goal: comparison of two scenarios with potential impact fraction (pif) approach
output_attribute_scen_1 <- attribute_health(
  exp_central = 8.85,   # EXPOSURE 1
  cutoff_central = 5,
  bhd_central = 25000,
  approach_risk = "relative_risk",
  erf_shape = "log_linear",
  rr_central = 1.118, rr_lower = 1.060, rr_upper = 1.179,
  rr_increment = 10
)
output_attribute_scen_2 <- attribute_health(
  exp_central = 6,      # EXPOSURE 2
  cutoff_central = 5,
  bhd_central = 25000,
  approach_risk = "relative_risk",
  erf_shape = "log_linear",
  rr_central = 1.118, rr_lower = 1.060, rr_upper = 1.179,
  rr_increment = 10
)
results <- compare(
  output_attribute_scen_1 = output_attribute_scen_1,
  output_attribute_scen_2 = output_attribute_scen_2,
  approach_comparison = "pif"
)
# Inspect the difference, stored in the impact column
results$health_main$impact


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
  \item Upstream: \code{\link{attribute_health}}, \code{\link{attribute_mod}},
    \code{\link{standardize}},
  \item Downstream: \code{\link{daly}}
}
}
\author{
Alberto Castro & Axel Luyten
}
