% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sisab.R
\name{sisab_data}
\alias{sisab_data}
\title{Download SISAB Coverage Data}
\usage{
sisab_data(
  year,
  type = "aps",
  level = "uf",
  month = NULL,
  uf = NULL,
  vars = NULL,
  cache = TRUE,
  cache_dir = NULL
)
}
\arguments{
\item{year}{Integer. Year(s) of the data. Required.}

\item{type}{Character. Report type to download. Default: \code{"aps"}
(APS coverage). See \code{\link{sisab_info}()} for all types.}

\item{level}{Character. Geographic aggregation level. Default:
\code{"uf"}. One of: \code{"brazil"}, \code{"region"}, \code{"uf"},
\code{"municipality"}.}

\item{month}{Integer. Month(s) to download (1--12). If NULL (default),
downloads all 12 months.}

\item{uf}{Character. Two-letter state abbreviation to filter by when
\code{level} is \code{"uf"} or \code{"municipality"}.
If NULL (default), returns all states.
Example: \code{"SP"}, \code{c("SP", "RJ")}.}

\item{vars}{Character vector. Variables to keep. If NULL (default),
returns all available variables. Use \code{\link{sisab_variables}()}
to see available variables.}

\item{cache}{Logical. If TRUE (default), caches downloaded data for
faster future access.}

\item{cache_dir}{Character. Directory for caching. Default:
\code{tools::R_user_dir("healthbR", "cache")}.}
}
\value{
A tibble with coverage data. Includes columns \code{year} and
\code{type} to identify the source when multiple years/types are
combined. Column names are preserved from the API (camelCase).
}
\description{
Downloads and returns primary care coverage data from the SISAB
relatorioaps API. Data is aggregated (coverage indicators per
geographic unit and period), not individual-level microdata.
}
\details{
Data is fetched from the relatorioaps REST API
(\verb{https://relatorioaps.saude.gov.br}), the public reporting portal
for primary care in Brazil.

Four report types are available:
\itemize{
\item \code{"aps"} (default): APS coverage -- number of primary care
teams (eSF, eAP, eSFR, eCR, eAPP) and estimated coverage percentage.
Available from 2019.
\item \code{"sb"}: Oral health coverage -- dental care teams and
coverage. Available from 2024.
\item \code{"acs"}: Community health agents -- number of active ACS
and population coverage. Available from 2007.
\item \code{"pns"}: PNS coverage -- coverage estimates from the
National Health Survey. Available 2020--2023.
}

For municipality-level data, it is recommended to filter by UF using the
\code{uf} parameter to avoid large downloads.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# APS coverage by state, January 2024
sisab_data(year = 2024, month = 1)

# National total, full year 2023
sisab_data(year = 2023, level = "brazil")

# Oral health coverage by UF
sisab_data(year = 2024, type = "sb", month = 6)

# Municipality level for Sao Paulo
sisab_data(year = 2024, level = "municipality", uf = "SP", month = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{sisab_info}()} for report type descriptions,
\code{\link{censo_populacao}()} for population denominators.

Other sisab: 
\code{\link{sisab_cache_status}()},
\code{\link{sisab_clear_cache}()},
\code{\link{sisab_info}()},
\code{\link{sisab_variables}()},
\code{\link{sisab_years}()}
}
\concept{sisab}
